/**
 * @file    ExternalDependencyConst.cs
 * 
 * @author  jschoi
 * @date    2024~
 * @copyright Copyright © Com2uS Platform Corporation. All Right Reserved.
 * @defgroup Hive.Unity.Editor
 * @{
 * @brief HIVE External Dependency Const <br/><br/>
 */

using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;
using System;
using System.IO;
using System.ComponentModel;
using System.Reflection;
using System.Xml;

namespace Hive.Unity.Editor
{
    public class ExternalDependencyConst
    {
        // Hive Dependencies Editor 설정 저장 파일 (SaveFile), Hive 23.4.0 이상, xml 파일
        public static readonly string projSettingsXmlDataPath = Path.Combine(Application.dataPath, "../ProjectSettings/HiveDependencies.xml");

        // 구 Hive Dependencies Editor 설정 저장 파일 (SaveFile), Hive 23.0.0 이상 ~ 23.4.0 미만, json 파일
        public static readonly string projSettingsJsonDataPath = Path.Combine(Application.dataPath, "../ProjectSettings/HiveExternalDependencyDictionary.json");

        // 구 Hive Dependencies Editor 설정 저장 파일 (SaveFile), Hive 4.16.1 이상 ~ 23.0.0 미만, json 파일
        public static readonly string jsonDataPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor/ExternalDependency/externalDependencyDictionary.json");

        // 구 Hive Dependencies Editor 설정 저장 파일 (SaveFile), Hive 4.16.1 미만, json 파일
        public static readonly string legacyJsonDataPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor/externalDependencyDictionary.json");


        // Hive_SDK_v4/Editor 경로
        public static readonly string editorPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor");
        // Hive_SDK_v4/Dependencies 경로
        public static readonly string dependenciesPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Dependencies");

        // AndroidSamplePostBuildProcess 파일 (샘플 파일 존재 여부 확인용)
        public static readonly string sampleFilePath = Path.Combine(Application.dataPath, "SampleBuilder/Editor/AndroidSamplePostBuildProcessor.cs");

        // HiveSDK 와 관련해 설정한 모든 디펜던시를 선언한 xml 파일
        public static readonly string hiveDependenciesXmlPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor/HiveSDKSettingsDependencies.xml");

        // HiveSDK Unity 패키지에서 디폴트 설정으로 전달되는 디펜던시 xml 파일
        public static readonly string hiveDependenciesTempXmlPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor/TempHiveSDKSettingsDependencies.xml");

        // 인터페이스 버전 파일 구조화
        [System.Serializable]
        public class VersionFileInfo
        {
            public string type;
            public string os;
            public string version;
        }

        // 인터페이스 버전 정보 획득
        // - 1단계 상위에 있는 HiveSDKInterfaceVersion.json 파일에서 "version" 키의 값을 반환합니다.
        public static string getInterfaceDependencyVersion()
        {
            try
            {
                var json = System.IO.File.ReadAllText(Path.Combine(Application.dataPath, "Hive_SDK_v4/Version/HiveSDKInterfaceVersion.json"));
                var versionFileInfo = JsonUtility.FromJson<VersionFileInfo>(json);
                return versionFileInfo.version;
            }
            catch (Exception e)
            {
                return "";
            }
        }
    }
}
